#!/usr/share/ucs-test/runner /usr/share/ucs-test/selenium
# -*- coding: utf-8 -*-
## desc: Test the creation and assigning of internet rules
## roles: [domaincontroller_master, domaincontroller_slave]
## tags: [apptest,ucsschool,ucsschool_selenium,ucs-school-umc-internetrules]
## exposure: dangerous
## packages:
##   - ucs-school-replica | ucs-school-singleserver

import random
import string

import univention.testing.ucsschool.ucs_test_school as utu
from univention.admin import localization
from univention.testing import selenium
from univention.testing.ucr import UCSTestConfigRegistry

translator = localization.translation("ucs-test-selenium")
_ = translator.translate


class UMCTester(object):
    def __init__(self, *args, **kwargs):
        self.selenium = None  # type: selenium.UMCSeleniumTest
        super(UMCTester, self).__init__(*args, **kwargs)

    def create_internet_rule(self, name, type, priority, urls, submit=True):
        self.selenium.click_text("Add rule")
        self.selenium.wait_for_text(_("Rule properties"), timeout=10)
        self.selenium.enter_input("name", name)
        self.selenium.enter_input_combobox("type", type)
        for index, url in enumerate(urls):
            self.selenium.enter_input("__domains-{}-0".format(str(index)), url)
            self.selenium.click_button("New entry")
        self.selenium.enter_input_combobox("priority", priority)
        if submit:
            self.selenium.click_button("Save")
            self.selenium.wait_for_text(name)  # rule name should show up in grid

    def test_umc(self):
        with utu.UCSTestSchool() as schoolenv:
            ucr = UCSTestConfigRegistry()
            schoolname, schooldn = schoolenv.create_ou()
            rulename_blacklist = "".join(random.choice(string.ascii_uppercase) for _ in range(10))

            # create new internet rule
            self.selenium.do_login()
            self.selenium.open_module(_("Define internet rules"), wait_for_standby=False)
            self.selenium.wait_until_standby_animation_appears_and_disappears(
                appear_timeout=15, disappear_timeout=60
            )
            self.create_internet_rule(
                rulename_blacklist, "Blacklist", 9, ["example.com", "example2.com"]
            )
            ucr.load()
            priority = ucr.get("proxy/filter/setting/{}/priority".format(rulename_blacklist))
            list_type = ucr.get("proxy/filter/setting/{}/filtertype".format(rulename_blacklist))
            d1 = ucr.get("proxy/filter/setting/{}/domain/blacklisted/1".format(rulename_blacklist))
            d2 = ucr.get("proxy/filter/setting/{}/domain/blacklisted/2".format(rulename_blacklist))
            assert (
                list_type == "blacklist-pass"
            ), "List type is {}, not blacklist-pass as expected".format(list_type)
            assert priority == "9", "Priority is {}, not 9 as expected".format(priority)
            assert d1 == "example.com", "Domain entry 1 is n{}, not example.com as expected".format(d1)
            assert d1 == "example.com", "Domain entry 1 is n{}, not example.com as expected".format(d2)

            # check if duplicate rule names are detected upon creation
            self.create_internet_rule(rulename_blacklist, "Blacklist", 9, [], submit=False)
            self.selenium.click_button("Save")
            self.selenium.wait_for_text(_("Notification"))  # Notification: rule name already exists
            self.selenium.click_button("Ok")
            self.selenium.wait_until_all_dialogues_closed()
            self.selenium.click_button("Back to overview")
            self.selenium.click_checkbox_of_grid_entry(rulename_blacklist)
            self.selenium.click_button("Delete")
            self.selenium.click_button("Remove rule")
            self.selenium.end_umc_session()


if __name__ == "__main__":
    with selenium.UMCSeleniumTest() as s:
        umc_tester = UMCTester()
        umc_tester.selenium = s

        umc_tester.test_umc()
