#!/usr/share/ucs-test/runner /usr/bin/pytest-3 -l -v
## -*- coding: utf-8 -*-
## desc: Test performance of GET /ucsschool/kelvin/v1/users/USERNAME (stable)
## tags: [kelvin, performance]
## exposure: safe
## packages: []
## bugs: []

import copy
from pathlib import Path

import pytest
from conftest import ENV_LOCUST_DEFAULTS, RESULT_DIR, set_locust_environment_vars
from locust_files.settings_kelvin import KELVIN_URL_BASE

LOCUST_ENV_VARIABLES = copy.deepcopy(ENV_LOCUST_DEFAULTS)
LOCUST_ENV_VARIABLES["LOCUST_RUN_TIME"] = "1m"
LOCUST_ENV_VARIABLES["LOCUST_STOP_TIMEOUT"] = "15"
LOCUST_ENV_VARIABLES["LOCUST_SPAWN_RATE"] = "0.1"  # add a user every 10s
LOCUST_ENV_VARIABLES["LOCUST_USERS"] = "4"  # should not overtax system

RESULT_FILES_NAME = "021-users-get-obj-stable"
RESULT_FILE_BASE_PATH = RESULT_DIR / RESULT_FILES_NAME
LOCUST_FILE_PATH = Path(__file__).parent / "locust_files" / "02_users_get_obj.py"
URL_NAME = f"{KELVIN_URL_BASE}/users/"


@pytest.fixture(scope="module")
def run_test(execute_test, verify_test_sent_requests, wait_for_replication, sleep10):
    set_locust_environment_vars(LOCUST_ENV_VARIABLES)
    execute_test(LOCUST_FILE_PATH, "GetUser", RESULT_FILE_BASE_PATH)
    # fail in fixture, so pytest prints the output of Locust,
    # regardless which test_*() function started Locust
    verify_test_sent_requests(RESULT_FILE_BASE_PATH)


def test_failure_count(check_failure_count, run_test):
    check_failure_count(RESULT_FILE_BASE_PATH)


def test_rps(check_rps, run_test):
    check_rps(RESULT_FILE_BASE_PATH, URL_NAME, 0.5)


def test_95_percentile(check_95_percentile, run_test):
    check_95_percentile(RESULT_FILE_BASE_PATH, URL_NAME, 2000)
