#!/usr/share/ucs-test/runner /usr/bin/pytest-3 -l -v
# -*- coding: utf-8 -*-
# desc: check performance of POST /ucsschool/apis/provisioning/v1/{school_authority}/users
## tags: [ucsschool-id-broker, provisioning-api, self-disclosure-api, performance]
## exposure: dangerous
## packages: []
## bugs: [54547]

import os
import subprocess
import sys

BASE_DIR = "/usr/share/ucs-test/98_ucsschool-id-broker-performance/"
PROV_TEST = "23_prov_users_post.py"
SD_TEST = "36_selfd_teacher_flow.py"
CMD1 = [os.path.join(BASE_DIR, PROV_TEST), "-f"]
CMD2 = [os.path.join(BASE_DIR, SD_TEST)]


def test_run_provisioning_and_self_disclosure_in_parallel():
    env = os.environ.copy()
    env["LOCUST_PARALLEL"] = "True"
    proc1 = subprocess.Popen(
        CMD1,
        env=env,
    )
    proc2 = subprocess.Popen(
        CMD2,
        env=env,
    )

    proc1.wait()
    proc2.wait()

    assert proc1.returncode == 0
    assert proc2.returncode == 0


if __name__ == "__main__":
    sys.exit(test_run_provisioning_and_self_disclosure_in_parallel())
