import pytest
from utils import add_test_service, remove_test_service

import univention.testing.strings as uts
from univention.config_registry import ConfigRegistry
from univention.udm import UDM
from univention.udm.encoders import Base64Bzip2BinaryProperty


@pytest.fixture()
def udm():
    return UDM.admin().version(2)


@pytest.fixture(scope="session")
def ucr():
    return ConfigRegistry().load()


@pytest.fixture()
def ldap_base(ucr):
    return ucr["ldap/base"]


@pytest.fixture()
def mappings_settings_data_dn(ldap_base):
    return f"cn=IDBrokerServiceProviderMappings,cn=IDBrokerSettings,cn=univention,{ldap_base}"


@pytest.fixture()
def secrets_settings_data_dn(ldap_base):
    return f"cn=IDBrokerServiceProviderSecrets,cn=IDBrokerSettings,cn=univention,{ldap_base}"


@pytest.fixture()
def preserve_settings_data(udm):
    settings = []

    def _preserve_settings_data(dn):
        obj = udm.obj_by_dn(dn)
        settings.append((dn, obj.props.data.raw))
        print(f"saving {dn}: {obj.props.data.raw}")
        obj.props.data = Base64Bzip2BinaryProperty("data", raw_value=b"{}")
        obj.save()

    yield _preserve_settings_data
    for dn, raw_data in settings:
        obj = udm.obj_by_dn(dn)
        obj.props.data = Base64Bzip2BinaryProperty("data", raw_value=raw_data)
        print(f"restore {dn}: {raw_data}")
        obj.save()


@pytest.fixture
def get_test_service_provider(
    preserve_settings_data, mappings_settings_data_dn, secrets_settings_data_dn
):
    """
    creates a service provider, which is removed after the test
    the original settings data object is saved and restored after the
    test.
    """
    service_providers = []

    def _handle_service_provider(service_provider: str):
        secret = uts.random_string()
        add_test_service(service_provider, secret)
        service_providers.append(service_provider)
        return secret

    preserve_settings_data(mappings_settings_data_dn)
    preserve_settings_data(secrets_settings_data_dn)

    yield _handle_service_provider

    for sp in service_providers:
        remove_test_service(sp)
