from typing import Dict, List

from locust import events, task
from locust.exception import StopUser
from sd_client import SelfDisclosureClient, get_student_data

data: List[Dict[str, str]] = []
counter = 0


@events.init.add_listener
def on_init(environment, **kwargs):
    data.extend(get_student_data())


class SDStudent(SelfDisclosureClient):
    def __init__(self, *args, **kwargs):
        global counter
        if counter >= len(data):
            raise StopUser("All loaded users are consumed.")
        super().__init__(*args, **kwargs)
        user_data = data[counter]
        self.username = user_data["username"]
        self.password = user_data["password"]
        self.idp_hint = user_data["idp_hint"]
        self.token = user_data["token"]
        self.pseudonym = user_data["pseudonym"]
        print(f"no.: {counter} user: {self.username}")
        counter += 1

    @task
    def get_user_metadata(self):
        super().get_user_metadata()
