# ID Broker plugins

## Intro
This repository contains a Debian source package for the ID Broker systems.
The following binary Debian packages are created from it:

* `id-broker-common`: scripts and code used in multiple other packages
* `ucs-test-id-broker-common`: tests for `id-broker-common`
* `id-broker-id-connector-plugin`: plugin for the ID Connector
* `id-broker-ldap-schema`: installation of LDAP schema, LDAP ACLs and extended UDM properties
* `id-broker-provisioning-api-plugin`: plugin for the `ucsschool-apis` app with the REST resources of the Provisioning API
* `id-broker-self-disclosure-api-plugin`: plugin for the `ucsschool-apis` app with the REST resources of the Self-Disclosure API

The Provisioning API and the Self-Disclosure APIs connect to the Kelvin REST API, the UDM REST API and OpenLDAP (directly) to CRUD users, groups and OUs.
The setup of those connections is configured through join scripts.

High level and also in-depth information on the ID Broker project can be found in the following documentation:

* Architecture documentation: https://univention.gitpages.knut.univention.de/id-broker/architecture-documentation/
* Operations manual (for Linet): https://univention.gitpages.knut.univention.de/id-broker/operations-manual/
* Documentation for school authorities: [published document](https://docs.software-univention.de/idbroker-school-authority-manual/) / [repository](https://git.knut.univention.de/univention/dev/docs/id-broker-school-authority-manual)
* Documentation for service providers: *TODO* -> https://git.knut.univention.de/univention/ucsschool/-/issues/506

## Installation & configuration

Installation instructions for the *Self-Disclosure API* can be found here: https://univention.gitpages.knut.univention.de/id-broker/operations-manual/installation.html#backup-self-disclosure-api

Installation instructions for the *Provisioning API* can be found here: https://univention.gitpages.knut.univention.de/id-broker/operations-manual/installation.html#backup-provisioning-api

## Run unittests local (ucsschool-api plugins)

- Start a ucsschool-apis container

```
docker run \
-v "$(pwd)/pyproject-common.toml:/var/lib/univention-appcenter/apps/ucsschool-apis/data/plugins/id-broker-common/pyproject.toml" \
-v "$(pwd)/id_broker_common:/var/lib/univention-appcenter/apps/ucsschool-apis/data/plugins/id-broker-common/id_broker_common" \
-v "$(pwd)/pyproject_provisioning.toml:/var/lib/univention-appcenter/apps/ucsschool-apis/data/plugins/id-broker-provisioning-api/pyproject.toml" \
-v "$(pwd)/provisioning_plugin:/var/lib/univention-appcenter/apps/ucsschool-apis/data/plugins/id-broker-provisioning-api/provisioning_plugin" \
-v "$(pwd)/pyproject_self_disclosure.toml:/var/lib/univention-appcenter/apps/ucsschool-apis/data/plugins/id-broker-self-disclosure-api/pyproject.toml" \
-v "$(pwd)/self_disclosure_plugin:/var/lib/univention-appcenter/apps/ucsschool-apis/data/plugins/id-broker-self-disclosure-api/self_disclosure_plugin" \
-v "$(pwd)/tests:/var/lib/univention-appcenter/apps/ucsschool-apis/data/tests" \
--rm -it -w "/var/lib/univention-appcenter/apps/ucsschool-apis/data/" \
docker.software-univention.de/ucsschool-apis:1.1.0 \
sh -c "update_api_plugins ./plugins && bash"
```

- You can now run the tests in the container

`pytest -lvv --disable-warnings tests/unittests`

## Run unittests local (ucsschool-id-connector plugin)

- Start a ucsschool-id-connector

```bash
docker run \
-v "$(pwd)/id_connector_plugin/packages:/var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/plugins/packages" \
-v "$(pwd)/id_connector_plugin/plugins:/var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/plugins/plugins" \
-v "$(pwd)/id_connector_plugin/tests:/var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/tests" \
--entrypoint "" \
--rm -it -w /var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/ \
docker.software-univention.de/ucsschool-id-connector:3.0.2 \
sh -c "pip install -r /ucsschool-id-connector/requirements-test.txt && bash"
```

- You can now run the tests in the container

`pytest -lvv --disable-warnings tests/unittests`


### Kelvin REST API

The Kelvin REST API will be configured by the join scripts to include the extended properties for the service provider specific pseudonyms (in `idBrokerPseudonym____`), the source objects `entryUUID` (in `ucsschoolRecordUID`), and the school authority (in `ucsschoolSourceUID`) it originates from.
The extended properties mapping configuration is in `/etc/ucsschool/kelvin/mapped_udm_properties.json`.

Additionally, the join scripts configure Kelvin to accept usernames with a length of up to `50` characters.
This is configured on `/var/lib/ucs-school-import/configs/kelvin.json`.

### Provisioning API and Self-Disclosure API configuration

It is assumed that the Provisioning API and the Self-Disclosure API are installed in different systems (UCS `backup` role).

The Provisioning API and Self-Disclosure API plugins for the `ucsschool-apis` apps are enabled in `/etc/ucsschool/apis/settings.json`.
This is also where their authentication strategies (provided by the `auth` plugin) are configured.

The APIs access the Kelvin REST API using the `ucsschool-apis` apps machine account.
The credentials are stored in `/etc/ucsschool/apis/id-broker/provisioning-api.json` and `/etc/ucsschool/apis/id-broker/self-disclosure-api.json` respectively.

## Build

The build will be done by a pipeline as long as you increased the changelog version.
If you need to build the package manually, you can do the following on `ladda`:

```
#!/bin/bash
RELEASE=5.0-0-0
SCOPE=id-broker
REPO="git@git.knut.univention.de:univention/components/ucsschool-api-plugins/id-broker-plugin.git"
BRANCH=main
package=id-broker-plugin
repo_admin.py -G "$REPO" -r "$RELEASE" -s "$SCOPE" -p $package -b "$BRANCH" -P . && b50-scope "$SCOPE" $package
```

## Publishing

All Debian packages, except for the ID Connector plugin, are distributed through a customer Debian repository (see operations manual).


```
@omar
announce_ucs_customer_scope -c 00342 -r 5.0-0 -s id-broker -v
sudo update_customer_mirror.sh -v 00342
```

The `id-broker-id-connector-plugin` is distributed through the regular UCS@school app Debian repositories (currently for `4.4 v9` and `5.0 v2`). To upload the package to the test appcenter, execute `./upload_id-connector-plugin_to_appcenter` and publish (sync) the test appcenter to the production appcenter. After that a normal app release.

```
# @local
./upload_id-connector-plugin_to_appcenter
# Get latest appcenter school version
curl --silent -o - https://appcenter.software-univention.de/meta-inf/5.0/index.json.gz | gzip -d -c | jq -r 'keys[]' | grep ucsschool_ | tail -n 1
```

```
# @omar
cd /var/univention/buildsystem2/mirror/appcenter
./copy_from_appcenter.test.sh 5.0 $LATEST_SCHOOL_VERSION
sudo update_mirror.sh -v appcenter
```

## Swagger UI

Both REST APIs can be accessed interactively through the Swagger UI at https://FQDN/ucsschool/apis/docs

## Performance tests

Performance tests for the Provisioning API and the Self disclosure API are done using Locust (http://docs.locust.io/).

Locust files are located in the `performance-tests/performance_tests` directory.
Test data is located in `performance-tests/data`.

The Locust files and test data can be used directly from git or can be installed by a Debian package.

To use them **from git**, create a virtual env and install the `setup.py`:

```bash
python3 -m venv venv
. venv/bin/activate
pip install -U pip wheel
pip install -e performance-tests
```

Then (after installing the test data - see `Test data for performance tests` below) execute for example:

```bash
locust --locustfile performance-tests/performance_tests/provisioning/school_classes_get.py
```

To run the performance tests **from UCS 5.0**, install the package `id-broker-performance-tests` and (after installing the test data) execute:

```bash
BASE_DIR="/var/lib/id-broker-performance-tests"
$BASE_DIR/venv/bin/locust --locustfile $BASE_DIR/performance_tests/provisioning/schools_head.py
```

### Locust commandline parameters

The default log level is `INFO`. To see debug messages, add to the command line: `--loglevel DEBUG`

To run it non-interactively add for example:

```
--host 10.200.3.83 --headless --users 10 --spawn-rate 1 --run-time 5m --stop-timeout 60 --csv=id_broker_school_class_get --html=id_broker_school_class_get.html --print-stats --exit-code-on-error 0
```

For more information see http://docs.locust.io/en/stable/running-without-web-ui.html

When Locust is started, it opens a web server at `http://0.0.0.0:8089`.
See http://docs.locust.io/en/stable/quickstart.html how to use it.

If one client CPU does not generate enough load on the server, see http://docs.locust.io/en/stable/running-distributed.html

### Automated (non-interactive) performance tests

A `ucs-test` package exists, that executes all locust files non-interactively.
It is configured and started by `performance-tests/run_tests`.
To run them manually, configure them through environment variables:

```bash
# the FQDN of the server running the Provisioning API:
export UCS_ENV_PROVISIONING_FQDN=provisioning1.broker.local
# start with 1 user, add 1 more every 20sec until 4 are running, stop after 4 minutes:
export LOCUST_USERS=4
export LOCUST_RUN_TIME=4m
export LOCUST_SPAWN_RATE=0.05
ucs-test -E dangerous -s ucsschool-id-broker-performance
```

See https://docs.locust.io/en/stable/configuration.html#all-available-configuration-options for the full list of available options.

The performance of the Locust executions will be evaluated in the ucs-tests.
The results in the form of CSV and HTML files can be found in `/var/lib/id-broker-performance-tests/results`.
The output of each Locust run will be redirected into `/var/lib/id-broker-performance-tests/results/<TEST>.log`

### Test data for performance tests

The performance tests require knowledge of school, class and user objects and their attributes, existing on the ID Broker and school authority systems.
That data is provided in the form of LDIF, JSON and SQLite files.

For more information about the creation of the LDIF, JSON and SQLite files see the respective [README](performance-tests/prepare_ldap/README.md).
