#!/usr/share/ucs-test/runner /usr/bin/pytest-3 -l -v
## -*- coding: utf-8 -*-
## desc: check performance of (teacher) GET /ucsschool/apis/self_disclosure/v1/users/{id}/groups
## tags: [ucsschool-id-broker, self-disclosure-api, performance]
## exposure: safe
## packages: []
## bugs: [54547]

import os.path

import pytest

BASE_DIR = "/var/lib/id-broker-performance-tests"
RESULT_DIR = os.path.join(BASE_DIR, "results")
LOCUST_FILES_DIR = os.path.join(BASE_DIR, "performance_tests", "self_disclosure")

LOCUST_FILE = "teacher_get_groups.py"
LOCUST_FILE_PATH = os.path.join(LOCUST_FILES_DIR, LOCUST_FILE)
RESULT_FILE_BASE_PATH = os.path.join(RESULT_DIR, "self-disclosure_teacher_get_groups")
HOST = "self-disclosure"
URL_NAME = "/ucsschool/apis/self_disclosure/v1/users/{id}/groups"


@pytest.fixture(scope="module")
def run_test(execute_test, host_from_env, verify_test_sent_requests):
    execute_test(LOCUST_FILE_PATH, RESULT_FILE_BASE_PATH, host_from_env(HOST))
    # fail in fixture, so pytest prints the output of Locust, regardless which test_*() function started Locust
    verify_test_sent_requests(RESULT_FILE_BASE_PATH)


def test_failure_count(check_failure_count, run_test):
    check_failure_count(RESULT_FILE_BASE_PATH)


def test_rps(check_rps, run_test):
    check_rps(
        RESULT_FILE_BASE_PATH, URL_NAME, 0.1
    )  # TODO: set desired target performance


def test_95_percentile(check_95_percentile, run_test):
    check_95_percentile(
        RESULT_FILE_BASE_PATH, URL_NAME, 10000
    )  # TODO: set desired target performance
