from typing import List

from fastapi import APIRouter

from ucsschool.apis.models import Plugin
from ucsschool.apis.utils import get_logger

# the name of the plugin which will also determine the name of the resource
PLUGIN_NAME: str = "idbroker-common"
# the plugins current version. Not used for anything in the ucsschool-apis app
PLUGIN_VERSION: str = "1.0.0"
# the plugins tags:
PLUGIN_TAGS: List[str] = []
# the router that will be mounted as the resource under the plugins name:
router: APIRouter = APIRouter()


def setup():
    logger = get_logger()
    logger.info(f"Setup of {PLUGIN_NAME!r} with version {PLUGIN_VERSION!r}.")


# This is the object that is referenced in the pyproject.toml as the plugin object:
IDBrokerPlugin = Plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_TAGS, router, setup)
