from __future__ import annotations

from typing import Dict, Optional, Sequence

from pydantic import BaseModel


class RawUser(BaseModel):
    """Simple user data object for retrieving data from DB (e.g. LDAP)."""

    dn: str
    firstname: str
    lastname: str
    record_uid: str
    schools: Sequence[str]
    source_uid: str
    synonyms: Dict[
        str, Optional[str]
    ]  # idBrokerPseudonym0023: 3ecc16f6-8f02-45b1-b27a-a2e76859f83f
    ucsschool_roles: Sequence[str]
    username: str
