import pytest
from fastapi import FastAPI
from fastapi.testclient import TestClient

from id_broker_common.kelvin import kelvin_session
from provisioning_plugin.plugin import router
from tests.unittests.utils import CLASS_SIZE, Dictable, get_preconfigured_session_mock
from ucsschool.apis.opa import opa_instance
from ucsschool.apis.utils import auth_manager


@pytest.fixture(autouse=True)
def no_wait_for_replication(mocker):
    mocker.patch("provisioning_plugin.routes.v1.users.wait_for_replication")
    mocker.patch("provisioning_plugin.routes.v1.schools.wait_for_replication")
    mocker.patch("provisioning_plugin.routes.v1.school_classes.wait_for_replication")
    mocker.patch("provisioning_plugin.routes.v1.users.ldap_access")
    mocker.patch("provisioning_plugin.routes.v1.schools.ldap_access")
    mocker.patch("provisioning_plugin.routes.v1.school_classes.ldap_access")
    mocker.patch(
        "provisioning_plugin.routes.v1.schools.kelvin_on_primary_session_kwargs"
    )


@pytest.fixture()
def broker_school():
    return Dictable(name="School1", display_name="School1 Display", id="School1-id")


@pytest.fixture()
def broker_student():
    return Dictable(
        id="student1",
        user_name="student1",
        first_name="stu1",
        last_name="dent",
        legal_guardians=[],
        legal_wards=[],
        context={
            "School1": {
                "classes": ["1a"],
                "workgroups": ["Wg1"],
                "roles": ["student"],
            }
        },
    )


@pytest.fixture()
def broker_school_class():
    return Dictable(
        name="1a",
        description="1a of School1",
        school="School1",
        members=[f"student{i}" for i in range(CLASS_SIZE)],
        id="1a-id",
    )


@pytest.fixture()
def broker_workgroup():
    return Dictable(
        name="Wg1",
        description="Wg1 of School1",
        school="School1",
        members=[f"student{i}" for i in range(CLASS_SIZE)],
        id="Wg1-id",
    )


@pytest.fixture
def func_client(fake_opa, async_dict):
    def _client(custom_overrides):
        app = FastAPI()
        app.include_router(router)
        overrides = {
            opa_instance: fake_opa,
            auth_manager: async_dict,
            kelvin_session: get_preconfigured_session_mock(),
        }
        # we need to overwrite fast api dependencies here.
        overrides.update(custom_overrides)
        app.include_router(router)
        # let's override the dependencies, so that we don't test more than we want
        for original, override in overrides.items():
            print(f"overriding {original} with {override}")
            app.dependency_overrides[original] = override  # todo typehints?
        return TestClient(app)

    return _client
