from typing import List

from fastapi import APIRouter

from id_broker_common.utils import load_settings, remove_passwords
from ucsschool.apis.models import Plugin
from ucsschool.apis.utils import auth_manager, get_logger

from .routes.v1 import groups as groups_routes_v1, users as users_routes_v1
from .settings import PLUGIN_SETTINGS_FILE

# the name of the plugin which will also determine the name of the resource
PLUGIN_NAME: str = "self_disclosure"
# the plugins current version. Not used for anything in the ucsschool-apis app
PLUGIN_VERSION: str = "1.1.0"
# the plugins tags:
PLUGIN_TAGS: List[str] = ["self_disclosure"]
# the router that will be mounted as the resource under the plugins name:
router: APIRouter = APIRouter()


def setup():
    logger = get_logger()
    logger.info(f"Setup of {PLUGIN_NAME} with version {PLUGIN_VERSION}.")
    # load config now to raise exception about errors as early as possible
    settings = load_settings(PLUGIN_SETTINGS_FILE)
    logger.info(
        "Settings in '%s': %r", PLUGIN_SETTINGS_FILE, remove_passwords(settings)
    )
    auth_manager.tags[PLUGIN_NAME] = "Tag for all self disclosure API endpoints"


router.include_router(users_routes_v1.router, prefix="/v1/users")
router.include_router(groups_routes_v1.router, prefix="/v1/groups")

# This is the object that is referenced in the pyproject.toml as the plugin object:
SelfDisclosurePlugin = Plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_TAGS, router, setup)
