# Tools to create reproducable school envs for ID Broker

Steps 1-4 only have to be applied once if the ldifs are prepared + copied on the corresponding vms (step 5+6).

## Initial steps (only run once)

### Create a template school on the traeger system

```
/usr/share/ucs-school-import/scripts/create_ou TEMPLATE
/usr/share/ucs-school-import/scripts/ucs-school-testuser-import --classes 30 --students 750 --teachers 30 --schools 1 TEMPLATE
```

### Save the ldif of the OU

```
slapcat  -a "(entryDN:dnSubtreeMatch:=ou=TEMPLATE,$(ucr get ldap/base))" -l /opt/template.ldif
slapcat  -a "(entryDN:dnSubtreeMatch:=cn=OUTEMPLATE-Klassenarbeit,cn=ucsschool,cn=groups,$(ucr get ldap/base))" >>  /opt/template.ldif
slapcat  -a "(entryDN:dnSubtreeMatch:=cn=OUtemplate-Member-Verwaltungsnetz,cn=ucsschool,cn=groups,$(ucr get ldap/base))" >>  /opt/template.ldif
slapcat  -a "(entryDN:dnSubtreeMatch:=cn=OUtemplate-DC-Verwaltungsnetz,cn=ucsschool,cn=groups,$(ucr get ldap/base))" >>  /opt/template.ldif
slapcat  -a "(entryDN:dnSubtreeMatch:=cn=OUtemplate-Member-Edukativnetz,cn=ucsschool,cn=groups,$(ucr get ldap/base))" >>  /opt/template.ldif
slapcat  -a "(entryDN:dnSubtreeMatch:=cn=OUtemplate-DC-Edukativnetz,cn=ucsschool,cn=groups,$(ucr get ldap/base))" >>  /opt/template.ldif
slapcat  -a "(entryDN:dnSubtreeMatch:=cn=admins-template,cn=ouadmins,cn=groups,$(ucr get ldap/base))" >>  /opt/template.ldif
```


### Call `clone_ou_diff`

This will create "clones" of the template ldif which we will add on the traeger systems & the id-broker system

```
mkdir -p "/tmp/testdata"
python3 clone_ou_diff --num_schools 800 --template_ldif "/opt/template.ldif" --template_ou_name "TEMPLATE" --num_traeger 2 --target_folder "/tmp/testdata"
```
This will take around 15 minutes.

You will get the following output structure:

- `/tmp/testdata/TraegerX/testdata/TraegerX-TEST-X.ldif` -> ldifs of schools on TraegerX
- `/tmp/testdata/id-broker/testdata/TraegerX-TEST-X.ldif` -> ldifs of the corresponding schools on the ID Broker system

-> You will import this later.

You will also get the corresponding uids, cns & ou names

- `/tmp/testdata/id-broker/testdata/TraegerX-TEST-X.json`
- `/tmp/testdata/testdata/TraegerX-TEST-X.json`

As well as a file with all the entries needed on the ID Broker

- `/tmp/testdata/id-broker/testdata/TraegerX-TEST-X users.json` (which also include the provisioning-admins)
- `/tmp/testdata/id-broker/testdata/TraegerX-TEST-X groups.json`
- `/tmp/testdata/id-broker/testdata/TraegerX-TEST-X schools.json`


This will be needed for the tests.

### Compress everything

```
cd /tmp/testdata/id-broker && XZ_OPT=-T0 tar -cJf id_broker_ldif.tar.xz testdata/*.tmpl
cd /tmp/testdata/Traeger1 && XZ_OPT=-T0 tar -cJf traeger1_ldif.tar.xz testdata/*.tmpl
cd /tmp/testdata/Traeger1 && XZ_OPT=-T0 tar -cJf traeger2_ldif.tar.xz testdata/*.tmpl
cd /tmp/testdata/id-broker && XZ_OPT=-T0 tar -cJf id_broker_json.tar.xz testdata/*.json
```
The latter contains all `Traeger*-TEST-*_users.json`, `Traeger*-TEST-*_groups.json` and `Traeger*-TEST-*_schools.json` files. Putting them inside one giant json is not a good idea.

We save the data here  `omar:/var/univention/buildsystem2/apt/ucs_5.0-0-id-broker-5.0/data`.

## Data access

- The test data is converted from the JSON files into a structure in a SQLite database for fast and easy access. This is done by the + Python function `performance_tests.common.json_to_dict_cache()`.
- The result is stored in `omar:/var/univention/buildsystem2/apt/ucs_5.0-0-id-broker-5.0/data/test-data-db.tar.xz`.
- After extraction to `/var/lib/id-broker-performance-tests/test-data-db`, the data can be accessed through the class `performance_tests.TestData`. For usage, see its docstring.



## Prepare the systems for the performance tests

The ID Broker ldifs have to be imported on all ID Broker VMs as well as the traeger ldifs on the corresponding traeger system.

None of the steps descrobed in the following sections should be neccessary.
They are only for documentation or if you want to run them separately.


Adapt your `/etc/hosts` so you have entries for the vms you want to use and set the following envs on your machine.

```
export UCS_ENV_TRAEGER1_FQDN="traeger1.traeger1.local"
export UCS_ENV_TRAEGER2_FQDN="traeger2.traeger2.local"
export UCS_ENV_BROKER_LDAPS="kc1.broker.local self-disclosure.broker.local provisioning.broker.local primary.broker.local"
```

The script `prepare_ldap/prepare_ldap.sh` takes care of the steps described below.

```
./prepare_ldap/prepare_ldap.sh
```

### Rename LDAP bases

Before importing the ldif files, the LDAP base has to be adjusted to the system.

The script `replace_ldap_base` can be used for this.

Copy the `.ldif.tmpl` files to the corresponding traeger system and call the script like:
```
python2 replace_ldap_base Traeger1
```

Copy the `.ldif.tmpl` files to the corresponding all ID Broker systems and call the script like:
```
python3 replace_ldap_base id-broker
```

### Importing the ldif files

In this step we will import the ldifs from the last step. Copy the script `import_ldifs.sh` to the system.
Adjust the name of the traeger and run this on the `Traeger1`, `Traeger2` and all of the ID Broker systems. The folder `testdata` includes either the data from `Traeger1`, `Traeger2` oder the ID Broker data. The VMs should have at least 4 GB of RAM.

```
import_ldifs.sh "testdata/*.ldif"
```

## Making sure everything worked

- You should be able to log in with our univention test app.
- You should be able to use the provisioning API (crud).
