import random
import time
from typing import Dict, List

from locust import events, task
from locust.exception import StopUser
from sd_client import SelfDisclosureClient, get_student_data
from testapp_client import get_access_token_and_pseudonym

data: List[Dict[str, str]] = []
counter = 0


@events.init.add_listener
def on_init(environment, **kwargs):
    data.extend(get_student_data(get_token=False))


class SDStudent(SelfDisclosureClient):
    def __init__(self, *args, **kwargs):
        global counter
        if counter >= len(data):
            raise StopUser("All loaded users are consumed.")
        super().__init__(*args, **kwargs)
        user_data = data[counter]
        self.username = user_data["username"]
        self.password = user_data["password"]
        self.idp_hint = user_data["idp_hint"]
        self.token = user_data["token"]
        self.pseudonym = user_data["pseudonym"]
        print(f"no.: {counter} user: {self.username}")
        counter += 1

    @task
    def flow(self):
        self.token, self.pseudonym = get_access_token_and_pseudonym(
            self.username, self.password, self.idp_hint, self.client
        )
        time.sleep(random.choice(range(12)))
        super().get_user_metadata()
        time.sleep(random.choice(range(12)))
        super().get_groups_of_user()
        time.sleep(9999999)
