import random
from typing import List, Tuple

from locust import events, task

from performance_tests.common import ProvisioningClient, TestData, get_provisioning_api_admins

user_credentials: List[Tuple[str, str]] = []  # [(username, password), ..]


@events.init.add_listener
def on_init(environment, **kwargs):
    data = TestData()
    user_credentials.extend(list(get_provisioning_api_admins(data).values()))


class ProvisioningAPIClient(ProvisioningClient):
    def on_start(self) -> None:
        pass  # don't fetch token

    @task
    def get_token(self) -> None:
        username, password = random.choice(user_credentials)
        self._get_fastapi_token(
            self.client, f"https://{self.host}{self.auth_token_url}", username, password
        )
