# -*- coding: utf-8 -*-
# Copyright 2022-2023 Univention GmbH
#
# http://www.univention.de/
#
# All rights reserved.
#
# The source code of this program is made available
# under the terms of the GNU Affero General Public License version 3
# (GNU AGPL V3) as published by the Free Software Foundation.
#
# Binary versions of this program provided by Univention to you as
# well as other copyrighted, protected or trademarked materials like
# Logos, graphics, fonts, specific documentations and configurations,
# cryptographic keys etc. are subject to a license agreement between
# you and Univention and not subject to the GNU AGPL V3.
#
# In the case you use this program under the terms of the GNU AGPL V3,
# the program is provided in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License with the Debian GNU/Linux or Univention distribution in file
# /usr/share/common-licenses/AGPL-3; if not, see
# <http://www.gnu.org/licenses/>.

import contextlib
import json
import os
from os.path import isfile, join
from typing import List

from ucsschool_id_connector.models import SchoolAuthorityConfiguration

CONFIG_PATH = "/var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/school_authorities"


class NoConfigFoundError(Exception):
    pass


def get_config_files(path: str) -> List:
    return [
        join(os.path.abspath(path), f)
        for f in os.listdir(os.path.abspath(path))
        if isfile(join(os.path.abspath(path), f)) and f.split(".")[1] == "json"
    ]


def read_id_broker_config(config_path, school_authority_name: str = None):
    for f in get_config_files(config_path):
        config = json.load(open(f))
        if "id_broker" in config["plugin_configs"]:
            if not school_authority_name or school_authority_name == config["name"]:
                with contextlib.suppress(Exception):
                    return SchoolAuthorityConfiguration(**config)
    raise NoConfigFoundError(f"No id broker configuration was found in {config_path}")
