# Integration tests for ID Broker

To run the ID Broker tests the following steps are needed:

The integration tests for the ID Broker plugin are not using SSL. To achieve this you have to set the environment
 variable `UNSAFE_SSL` on the target system inside the UCS\@school APIs container.

From the host system run:

```shell
univention-app shell ucsschool-apis sh -c 'export UNSAFE_SSL=1 && /etc/init.d/ucsschool-apis restart'
```

Or from inside the ID Connector container run:

```shell
export UNSAFE_SSL=1 && /etc/init.d/ucsschool-id-connector restart'
```

Before running the tests, install its Python dependencies:

```shell
univention-app shell ucsschool-id-connector python3 -m pip install -r /var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/tests/id_broker/requirements.txt
```

Before running the integration tests, make sure to remove all remaining school_authority configurations.
To run only the tests for the ID Broker plugin, run:

```shell
univention-app shell ucsschool-id-connector sh -c "export UNSAFE_SSL=1 && cd /var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/tests/id_broker && python3 -m pytest -lv -m 'id_broker and not id_broker_compatibility'"
```
