# from unittest.mock import AsyncMock
#
# import pytest
# from fastapi.testclient import TestClient
#
# from id_broker_plugin import id_broker_plugin
# from id_broker_common.kelvin import kelvin_session
# from id_broker_common.plugin_reg import opa_instance, router
# from ucsschool.apis.plugins.auth import oauth2_scheme
#
# from . import utils
#
#
# @pytest.fixture(scope="session")
# def client(app, dependency_overrides, fake_opa, async_dict):
#     # FastAPI Depends() overrides for complete session
#     app.include_router(router)
#     overrides = {
#         opa_instance: fake_opa,
#         oauth2_scheme: async_dict,
#         kelvin_session: utils.get_preconfigured_session_mock(),
#     }
#     dependency_overrides(overrides)
#     return TestClient(app)
#
#
# # ------------------------ the tests -------------------------
#
#
# def test_user_get_correct_broker_id(client, monkeypatch):
#     users = [utils.Dictable(name="correct-user")]
#     monkeypatch.setattr(id_broker_plugin, "user_getter_by_broker_id", AsyncMock(return_value=users))
#     response = client.get("/user?broker_id=foobar1")
#     assert response.status_code == 200
#     assert response.json() == users[0]
#
#
# def test_user_get_wrong_broker_id(client, monkeypatch):
#     users = []
#     monkeypatch.setattr(id_broker_plugin, "user_getter_by_broker_id", AsyncMock(return_value=users))
#     response = client.get("/user?broker_id=foobar2")
#     assert response.status_code == 404
#
#
# def test_too_many_users(client, monkeypatch):
#     users = [{}, {}]
#     monkeypatch.setattr(id_broker_plugin, "user_getter_by_broker_id", AsyncMock(return_value=users))
#     response = client.get("/user?broker_id=foobar3")
#     assert response.status_code == 500
