import os

import pytest
import requests

DEFAULT_PASSWORD = "univentionunivention"
DEFAULT_SCHOOL_AUTHORITY = "TEST"
DEFAULT_SCHOOL_NAME = "School1"

EXPECTED_HEADER_NAME = "X-Request-ID"

must_run_in_docker = pytest.mark.skipif(
    "DOCKER_HOST_NAME" not in os.environ, reason="Integration tests should only run in container"
)


def get_access_token(
    username: str = f"provisioning-{DEFAULT_SCHOOL_AUTHORITY}", password: str = DEFAULT_PASSWORD
) -> str:
    response = requests.post(
        url=f"http://{os.environ['DOCKER_HOST_NAME']}/ucsschool/apis/auth/token",
        headers={"Content-Type": "application/x-www-form-urlencoded"},
        data=dict(username=username, password=password),
    )
    assert response.status_code == 200, f"{response.__dict__!r}"
    response_json = response.json()
    return response_json["access_token"]
