import pytest
from selenium import webdriver

from univention.id_broker.pseudonyms_udm_host import (
    get_service_provider_attribute_dn,
    get_settings_data_content,
)
from univention.udm import UDM


@pytest.fixture(scope="module")
def udm():
    return UDM.admin().version(2)


@pytest.fixture()
def service_providers() -> list:
    return get_settings_data_content(get_service_provider_attribute_dn()).keys()


@pytest.fixture
def selenium() -> webdriver.Chrome:
    """
    Browser based testing for using Selenium.
    """
    chrome_options = webdriver.ChromeOptions()
    chrome_options.add_argument("--no-sandbox")  # chrome complains about being executed as root
    chrome_options.add_argument("ignore-certificate-errors")
    driver = webdriver.Chrome(options=chrome_options)
    return driver
