import os
from typing import Tuple

from ucsschool.lib.models.utils import exec_cmd
from univention.udm import UDM


def _env_is_not_empty():
    """
    This function can be used to run tests only in an environment, which has no
    provisioned users, groups & ous.
    To overwrite this, set the environment variable FORCE2RUN_SKIPPED_TEST='1'.
    """
    udm = UDM.admin().version(2)
    num_provisioned = 0
    for entity in ["users/user", "groups/group", "container/ou"]:
        mod = udm.get(entity)
        num_provisioned += len(list(mod.search("(&(ucsschoolSourceUID=*)(ucsschoolRecordUID=*))")))
    return not num_provisioned or os.getenv("FORCE2RUN_SKIPPED_TEST") != "1"


def add_test_service(
    service_provider: str, secret: str, overwrite: bool = False
) -> Tuple[int, str, str]:
    print(f"create test service provider {service_provider} with secret {secret}")
    cmd = [
        "manage-service-providers",
        "addservice",
        "--name",
        service_provider,
        "--secret",
        secret,
    ]
    if overwrite:
        cmd.append("--overwrite")
    return exec_cmd(cmd)


def remove_test_service(service_provider: str) -> None:
    print(f"remove test service provider {service_provider}")
    exec_cmd(
        [
            "manage-service-providers",
            "removeservice",
            "--name",
            service_provider,
        ]
    )
