# idbroker.provisioning-api
This application exposes network resources introduced via custom plugins.

The `idbroker.provisioning_api` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.0
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3
* six >= 1.10
* python-dateutil
* aiohttp

## Getting Started

In your own code, to use this library to connect and interact with idbroker.provisioning-api,
you can run the following:

```python
from __future__ import print_function

import time
import idbroker.provisioning_api
from idbroker.provisioning_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = idbroker.provisioning_api.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with idbroker.provisioning_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = idbroker.provisioning_api.AuthApi(api_client)
    username = 'username_example' # str | 
password = 'password_example' # str | 
grant_type = 'grant_type_example' # str |  (optional)
scope = '' # str |  (optional) (default to '')
client_id = 'client_id_example' # str |  (optional)
client_secret = 'client_secret_example' # str |  (optional)

    try:
        # Login For Access Token
        api_response = api_instance.login_for_access_token_ucsschool_apis_auth_token_post(username, password, grant_type=grant_type, scope=scope, client_id=client_id, client_secret=client_secret)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthApi->login_for_access_token_ucsschool_apis_auth_token_post: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**login_for_access_token_ucsschool_apis_auth_token_post**](idbroker/provisioning_api/docs/AuthApi.md#login_for_access_token_ucsschool_apis_auth_token_post) | **POST** /ucsschool/apis/auth/token | Login For Access Token
*ProvisioningApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_classes_id_delete**](idbroker/provisioning_api/docs/ProvisioningApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_classes_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Delete
*ProvisioningApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete**](idbroker/provisioning_api/docs/ProvisioningApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/schools/{id} | Delete
*ProvisioningApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_users_id_delete**](idbroker/provisioning_api/docs/ProvisioningApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_users_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Delete
*ProvisioningApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_delete**](idbroker/provisioning_api/docs/ProvisioningApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Delete
*ProvisioningApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_classes_id_get**](idbroker/provisioning_api/docs/ProvisioningApi.md#get_ucsschool_apis_provisioning_v1_school_authority_classes_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Get
*ProvisioningApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_classes_id_head**](idbroker/provisioning_api/docs/ProvisioningApi.md#get_ucsschool_apis_provisioning_v1_school_authority_classes_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Get
*ProvisioningApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get**](idbroker/provisioning_api/docs/ProvisioningApi.md#get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/schools/{id} | Get
*ProvisioningApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_users_id_get**](idbroker/provisioning_api/docs/ProvisioningApi.md#get_ucsschool_apis_provisioning_v1_school_authority_users_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Get
*ProvisioningApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_users_id_head**](idbroker/provisioning_api/docs/ProvisioningApi.md#get_ucsschool_apis_provisioning_v1_school_authority_users_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Get
*ProvisioningApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_get**](idbroker/provisioning_api/docs/ProvisioningApi.md#get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Get
*ProvisioningApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_head**](idbroker/provisioning_api/docs/ProvisioningApi.md#get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Get
*ProvisioningApi* | [**head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head**](idbroker/provisioning_api/docs/ProvisioningApi.md#head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/schools/{id} | Head
*ProvisioningApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_classes_post**](idbroker/provisioning_api/docs/ProvisioningApi.md#post_ucsschool_apis_provisioning_v1_school_authority_classes_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/classes | Post
*ProvisioningApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_schools_post**](idbroker/provisioning_api/docs/ProvisioningApi.md#post_ucsschool_apis_provisioning_v1_school_authority_schools_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/schools | Post
*ProvisioningApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_users_post**](idbroker/provisioning_api/docs/ProvisioningApi.md#post_ucsschool_apis_provisioning_v1_school_authority_users_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/users | Post
*ProvisioningApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_workgroups_post**](idbroker/provisioning_api/docs/ProvisioningApi.md#post_ucsschool_apis_provisioning_v1_school_authority_workgroups_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups | Post
*ProvisioningApi* | [**put_ucsschool_apis_provisioning_v1_school_authority_classes_id_put**](idbroker/provisioning_api/docs/ProvisioningApi.md#put_ucsschool_apis_provisioning_v1_school_authority_classes_id_put) | **PUT** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Put
*ProvisioningApi* | [**put_ucsschool_apis_provisioning_v1_school_authority_users_id_put**](idbroker/provisioning_api/docs/ProvisioningApi.md#put_ucsschool_apis_provisioning_v1_school_authority_users_id_put) | **PUT** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Put
*ProvisioningApi* | [**put_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_put**](idbroker/provisioning_api/docs/ProvisioningApi.md#put_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_put) | **PUT** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Put
*SchoolClassesApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_classes_id_delete**](idbroker/provisioning_api/docs/SchoolClassesApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_classes_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Delete
*SchoolClassesApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_classes_id_get**](idbroker/provisioning_api/docs/SchoolClassesApi.md#get_ucsschool_apis_provisioning_v1_school_authority_classes_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Get
*SchoolClassesApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_classes_id_head**](idbroker/provisioning_api/docs/SchoolClassesApi.md#get_ucsschool_apis_provisioning_v1_school_authority_classes_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Get
*SchoolClassesApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_classes_post**](idbroker/provisioning_api/docs/SchoolClassesApi.md#post_ucsschool_apis_provisioning_v1_school_authority_classes_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/classes | Post
*SchoolClassesApi* | [**put_ucsschool_apis_provisioning_v1_school_authority_classes_id_put**](idbroker/provisioning_api/docs/SchoolClassesApi.md#put_ucsschool_apis_provisioning_v1_school_authority_classes_id_put) | **PUT** /ucsschool/apis/provisioning/v1/{school_authority}/classes/{id} | Put
*SchoolsApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete**](idbroker/provisioning_api/docs/SchoolsApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/schools/{id} | Delete
*SchoolsApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get**](idbroker/provisioning_api/docs/SchoolsApi.md#get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/schools/{id} | Get
*SchoolsApi* | [**head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head**](idbroker/provisioning_api/docs/SchoolsApi.md#head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/schools/{id} | Head
*SchoolsApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_schools_post**](idbroker/provisioning_api/docs/SchoolsApi.md#post_ucsschool_apis_provisioning_v1_school_authority_schools_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/schools | Post
*UsersApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_users_id_delete**](idbroker/provisioning_api/docs/UsersApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_users_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Delete
*UsersApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_users_id_get**](idbroker/provisioning_api/docs/UsersApi.md#get_ucsschool_apis_provisioning_v1_school_authority_users_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Get
*UsersApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_users_id_head**](idbroker/provisioning_api/docs/UsersApi.md#get_ucsschool_apis_provisioning_v1_school_authority_users_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Get
*UsersApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_users_post**](idbroker/provisioning_api/docs/UsersApi.md#post_ucsschool_apis_provisioning_v1_school_authority_users_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/users | Post
*UsersApi* | [**put_ucsschool_apis_provisioning_v1_school_authority_users_id_put**](idbroker/provisioning_api/docs/UsersApi.md#put_ucsschool_apis_provisioning_v1_school_authority_users_id_put) | **PUT** /ucsschool/apis/provisioning/v1/{school_authority}/users/{id} | Put
*WorkgroupsApi* | [**delete_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_delete**](idbroker/provisioning_api/docs/WorkgroupsApi.md#delete_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_delete) | **DELETE** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Delete
*WorkgroupsApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_get**](idbroker/provisioning_api/docs/WorkgroupsApi.md#get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_get) | **GET** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Get
*WorkgroupsApi* | [**get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_head**](idbroker/provisioning_api/docs/WorkgroupsApi.md#get_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_head) | **HEAD** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Get
*WorkgroupsApi* | [**post_ucsschool_apis_provisioning_v1_school_authority_workgroups_post**](idbroker/provisioning_api/docs/WorkgroupsApi.md#post_ucsschool_apis_provisioning_v1_school_authority_workgroups_post) | **POST** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups | Post
*WorkgroupsApi* | [**put_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_put**](idbroker/provisioning_api/docs/WorkgroupsApi.md#put_ucsschool_apis_provisioning_v1_school_authority_workgroups_id_put) | **PUT** /ucsschool/apis/provisioning/v1/{school_authority}/workgroups/{id} | Put


## Documentation For Models

 - [HTTPValidationError](idbroker/provisioning_api/docs/HTTPValidationError.md)
 - [School](idbroker/provisioning_api/docs/School.md)
 - [SchoolClass](idbroker/provisioning_api/docs/SchoolClass.md)
 - [SchoolContext](idbroker/provisioning_api/docs/SchoolContext.md)
 - [Token](idbroker/provisioning_api/docs/Token.md)
 - [User](idbroker/provisioning_api/docs/User.md)
 - [ValidationError](idbroker/provisioning_api/docs/ValidationError.md)
 - [WorkGroup](idbroker/provisioning_api/docs/WorkGroup.md)


## Documentation For Authorization


## OAuth2PasswordBearer

- **Type**: OAuth
- **Flow**: password
- **Authorization URL**: 
- **Scopes**: N/A


## Author




