//  memory simd functions
//  Copyright (C) 2009 Tim Blechmann
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.


#ifndef SIMD_MEMORY_HPP
#define SIMD_MEMORY_HPP

#include "simd_unroll_constraints.hpp"

#include "simd_memory_generic.hpp"

#ifdef __SSE__
#include "simd_memory_sse.hpp"
#else
#include "simd_memory_fallback_float.hpp"
#include "simd_memory_fallback_double.hpp"
#endif


namespace nova {

template <unsigned int n>
inline void copyvec_nn_simd(float * dest, const float * src)
{
    copyvec_nn_simd(dest, src, n);
}

template <unsigned int n>
inline void copyvec_an_simd(float * dest, const float * src)
{
    copyvec_an_simd(dest, src, n);
}

template <unsigned int n>
inline void copyvec_na_simd(float * dest, const float * src)
{
    copyvec_na_simd(dest, src, n);
}

template <unsigned int n>
inline void copyvec_nn_simd_mp(double * dest, const double * src)
{
    copyvec_nn_simd(dest, src, n);
}

template <unsigned int n>
inline void copyvec_an_simd(double * dest, const double * src)
{
    copyvec_an_simd(dest, src, n);
}

template <unsigned int n>
inline void copyvec_na_simd_mp(double * dest, const double * src)
{
    copyvec_na_simd(dest, src, n);
}


template <unsigned int n>
inline void addvec_simd(float * dest, const float * in)
{
    addvec_simd(dest, in, n);
}

template <unsigned int n>
inline void addvec_simd(float * dest, const float in)
{
    addvec_simd(dest, in, n);
}

template <unsigned int n>
inline void addvec_simd(float * dest, const float in, const float slope)
{
    addvec_simd(dest, in, slope, n);
}


template <unsigned int n>
inline void addvec_simd(double * dest, const double * in)
{
    addvec_simd(dest, in, n);
}

template <unsigned int n>
inline void addvec_simd(double * dest, const double in)
{
    addvec_simd(dest, in, n);
}

template <unsigned int n>
inline void addvec_simd(double * dest, const double in, const double slope)
{
    addvec_simd(dest, in, slope, n);
}


} /* namespace nova */

#endif /* SIMD_MEMORY_HPP */
