#!/usr/share/ucs-test/runner /usr/bin/pytest-3 -l -v
## -*- coding: utf-8 -*-
## desc: check performance of keycloak, get access token
## tags: [ucsschool-id-broker, keycloak, performance]
## exposure: safe
## packages: []
## bugs: [54547]

import os

import pytest

BASE_DIR = "/var/lib/id-broker-performance-tests"
RESULT_DIR = os.path.join(BASE_DIR, "results")
LOCUST_FILES_DIR = os.path.join(BASE_DIR, "performance_tests", "keycloak")

LOCUST_FILE = "get_access_token.py"
LOCUST_FILE_PATH = os.path.join(LOCUST_FILES_DIR, LOCUST_FILE)
RESULT_FILE_BASE_PATH = os.path.join(RESULT_DIR, "keycloak_get_access_token")
HOST = "testapp"
URL_NAMES = [
    "/auth/realms/ID-Broker/auth/login",
    "/auth/realms/ID-Broker/broker/{traeger}/endpoint",
    "univention-test-app/authorize",
]


@pytest.fixture(scope="module")
def run_test(execute_test, host_from_env):
    os.environ["LOCUST_SPAWN_RATE"] = "5"
    os.environ["LOCUST_USERS"] = "50"
    execute_test(LOCUST_FILE_PATH, RESULT_FILE_BASE_PATH, host_from_env(HOST))


def test_failure_count(check_failure_count, run_test):
    check_failure_count(RESULT_FILE_BASE_PATH)


def test_rps(check_rps, run_test):
    for url_name in URL_NAMES:
        check_rps(RESULT_FILE_BASE_PATH, url_name, 8.0)


def test_95_percentile(check_95_percentile_multirow, run_test):
    check_95_percentile_multirow(RESULT_FILE_BASE_PATH, URL_NAMES, 1500)
