#!/bin/bash
#
# Copyright 2022-2023 Univention GmbH
#
# http://www.univention.de/
#
# All rights reserved.
#
# The source code of this program is made available
# under the terms of the GNU Affero General Public License version 3
# (GNU AGPL V3) as published by the Free Software Foundation.
#
# Binary versions of this program provided by Univention to you as
# well as other copyrighted, protected or trademarked materials like
# Logos, graphics, fonts, specific documentations and configurations,
# cryptographic keys etc. are subject to a license agreement between
# you and Univention and not subject to the GNU AGPL V3.
#
# In the case you use this program under the terms of the GNU AGPL V3,
# the program is provided in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License with the Debian GNU/Linux or Univention distribution in file
# /usr/share/common-licenses/AGPL-3; if not, see
# <http://www.gnu.org/licenses/>.

set -e
set -x

compress_if_larger_than () {
  local path="${1:-}" max_size="${2:-}"

  file_size=$(stat -c%s "$path")
  if (( file_size > max_size )); then
    pbzip2 -9 "$path"
  fi
}

compress_large_logs () {
  for path in /var/lib/id-broker-performance-tests/results/*.log; do
    compress_if_larger_than "$path" 1048576
  done
}

if ! (which git > /dev/null && which pbzip2 > /dev/null); then
	apt-get -y update
	apt-get -y install git pbzip2
fi

if [ -n "$UCS_ENV_GIT_RESULTS_ACCESS_TOKEN" ] && [ -n "$JOB_NAME" ]; then
	curl -k https://nissedal.knut.univention.de/ucs-root-ca.crt > /usr/local/share/ca-certificates/univention.crt
	update-ca-certificates
	git config --global --add user.name "Jenkins ID Broker Performance Tests"
	git config --global --add user.email "brokertests@jenkins"
	git clone "https://token:$UCS_ENV_GIT_RESULTS_ACCESS_TOKEN@git.knut.univention.de/univention/id-broker/performance-test-results.git" /tmp/performance-test-results
	test_name="$(basename "$JOB_NAME")"
	version="$(ucr get version/version)"
	result_dir="results-$(date +%Y-%m-%d-%H-%M)"
	cd /tmp/performance-test-results
	mkdir -p "$version/$test_name/$result_dir"
	compress_large_logs
	cp -rf /var/lib/id-broker-performance-tests/system-information "$version/$test_name/$result_dir/"
	cp -rf /var/lib/id-broker-performance-tests/results/* "$version/$test_name/$result_dir/"
	# shellcheck disable=SC2035
	git add *
	git commit -a -m "Performance test results update for job \"$JOB_NAME\""
	git push
fi

exit 0
