#!/usr/bin/python3

# -*- coding: utf-8 -*-
#
# Copyright 2022-2023 Univention GmbH
#
# https://www.univention.de/
#
# All rights reserved.
#
# The source code of this program is made available
# under the terms of the GNU Affero General Public License version 3
# (GNU AGPL V3) as published by the Free Software Foundation.
#
# Binary versions of this program provided by Univention to you as
# well as other copyrighted, protected or trademarked materials like
# Logos, graphics, fonts, specific documentations and configurations,
# cryptographic keys etc. are subject to a license agreement between
# you and Univention and not subject to the GNU AGPL V3.
#
# In the case you use this program under the terms of the GNU AGPL V3,
# the program is provided in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License with the Debian GNU/Linux or Univention distribution in file
# /usr/share/common-licenses/AGPL-3; if not, see
# <https://www.gnu.org/licenses/>.


import json
import os

# either http://192.168.0.10/build2/ucs_5.0-0-id-broker-5.0/data for internal test, or
# http://updates-test.software-univention.de/5.0/maintained/component/idbroker_DEVEL/data/ for test in ec2
data_url = (
    os.environ["UCS_ENV_ANSIBLE_DATA_URL"]
    if "UCS_ENV_ANSIBLE_DATA_URL" in os.environ
    else "http://192.168.0.10/build2/ucs_5.0-0-id-broker-5.0/data"
)

inventory = {
    "ldap_server": {
        "hosts": [
            os.environ["UCS_ENV_TRAEGER1_FQDN"],
            os.environ["UCS_ENV_TRAEGER2_FQDN"],
        ],
        "vars": {
            "ansible_python_interpreter": "/usr/bin/python3",
            "ansible_ssh_private_key_file": os.environ["UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY"],
            "ansible_ssh_user": os.environ["UCS_ENV_ANSIBLE_SSH_USER"],
            "ansible_ssh_common_args": "-o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null",
        },
    },
    "jump_hosts": {
        "hosts": ["jump_host"],
        "vars": {
            "ansible_python_interpreter": "/usr/bin/python3",
            "ansible_ssh_private_key_file": os.environ["UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY"],
            "ansible_ssh_user": os.environ["UCS_ENV_ANSIBLE_SSH_USER"],
            "ansible_ssh_common_args": "-o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null",
        },
    },
    "_meta": {
        "hostvars": {
            os.environ["UCS_ENV_TRAEGER1_FQDN"]: {
                "ansible_host": os.environ["UCS_ENV_TRAEGER1_FQDN"],
                "ldif_url": f"{data_url}/traeger1_ldif.tar.xz",
            },
            os.environ["UCS_ENV_TRAEGER2_FQDN"]: {
                "ansible_host": os.environ["UCS_ENV_TRAEGER2_FQDN"],
                "ldif_url": f"{data_url}/traeger2_ldif.tar.xz",
            },
            "jump_host": {
                "ansible_host": "localhost",
            },
        }
    },
}

# for the broker domain, we may need other ssh keys
# connection in testing env via proxy
ssh_key = (
    os.environ["UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY_BROKER"]
    if "UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY_BROKER" in os.environ
    else os.environ["UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY"]
)
ssh_user = (
    os.environ["UCS_ENV_ANSIBLE_SSH_USER_BROKER"]
    if "UCS_ENV_ANSIBLE_SSH_USER_BROKER" in os.environ
    else os.environ["UCS_ENV_ANSIBLE_SSH_USER"]
)
ssh_sudo_password = (
    os.environ["UCS_ENV_ANSIBLE_SUDO_PASSWORD_BROKER"]
    if "UCS_ENV_ANSIBLE_SUDO_PASSWORD_BROKER" in os.environ
    else None
)

for broker_system in os.environ["UCS_ENV_BROKER_LDAPS"].split(" "):
    inventory["ldap_server"]["hosts"].append(broker_system)
    inventory["_meta"]["hostvars"][broker_system] = {
        "ansible_host": broker_system,
        "ldif_url": f"{data_url}/id_broker_ldif.tar.xz",
        "ansible_ssh_private_key_file": ssh_key,
        "ansible_ssh_user": ssh_user,
    }
    if ssh_sudo_password:
        inventory["_meta"]["hostvars"][broker_system]["ansible_become"] = "yes"
        inventory["_meta"]["hostvars"][broker_system]["ansible_become_password"] = ssh_sudo_password

print(json.dumps(inventory))
