# -*- coding: utf-8 -*-
# Copyright 2022-2023 Univention GmbH
#
# http://www.univention.de/
#
# All rights reserved.
#
# The source code of this program is made available
# under the terms of the GNU Affero General Public License version 3
# (GNU AGPL V3) as published by the Free Software Foundation.
#
# Binary versions of this program provided by Univention to you as
# well as other copyrighted, protected or trademarked materials like
# Logos, graphics, fonts, specific documentations and configurations,
# cryptographic keys etc. are subject to a license agreement between
# you and Univention and not subject to the GNU AGPL V3.
#
# In the case you use this program under the terms of the GNU AGPL V3,
# the program is provided in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License with the Debian GNU/Linux or Univention distribution in file
# /usr/share/common-licenses/AGPL-3; if not, see
# <http://www.gnu.org/licenses/>.
import sys
from unittest.mock import patch

import pytest

from ucsschool_id_connector.models import (
    ListenerGroupAddModifyObject,
    ListenerGroupRemoveObject,
    ListenerUserAddModifyObject,
    ListenerUserRemoveObject,
    SchoolAuthorityConfiguration,
)
from ucsschool_id_connector.utils import school_class_dn_regex, workgroup_dn_regex

sys.path.append("/ucsschool-id-connector/src/plugins/packages/")
sys.path.append("/var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/plugins/packages")
sys.path.append("/var/lib/univention-appcenter/apps/ucsschool-id-connector/conf/plugins/plugins")

from id_broker_handlers import IDBrokerPerSAGroupDispatcher, IDBrokerPerSAUserDispatcher  # noqa: E402


@pytest.fixture
def school_authority_conf():
    return SchoolAuthorityConfiguration(
        **{
            "name": "TEST",
            "active": True,
            "url": "https://fqdn/",
            "plugins": ["id_broker-users", "id_broker-groups"],
            "plugin_configs": {
                "id_broker": {
                    "password": "password",
                    "username": "provisioning-TEST",
                    "version": 1,
                    "schools": [],
                },
            },
        },
    )


@pytest.fixture
def workgroup_dn():
    return "cn=DEMOSCHOOL-wg1,cn=schueler,cn=groups,ou=DEMOSCHOOL,dc=ldap,dc=base"


@pytest.fixture
def school_class_dn():
    return "cn=DEMOSCHOOL-1a,cn=klassen,cn=schueler,cn=groups,ou=DEMOSCHOOL,dc=ldap,dc=base"


@pytest.fixture
def user_dn():
    return "uid=teach3,cn=lehrer,cn=users,ou=ou1,dc=ldap,dc=base"


@pytest.fixture
def get_listener_group_add_modify_object():
    def _func(**kwargs):
        return ListenerGroupAddModifyObject(
            dn=kwargs.get("dn"),
            id=kwargs.get("id", "TEST-GROUP"),
            udm_object_type="groups/group",
            object=kwargs.get("object", {}),
            options=[],
        )

    return _func


@pytest.fixture
def get_listener_group_remove_object():
    def _func(**kwargs):
        return ListenerGroupRemoveObject(
            dn=kwargs.get("dn"),
            id=kwargs.get("id", "TEST-GROUP"),
            udm_object_type="groups/group",
        )

    return _func


@pytest.fixture
def get_listener_user_add_modify_object():
    def _func(**kwargs):
        return ListenerUserAddModifyObject(
            dn=kwargs.get("dn"),
            id=kwargs.get("id", "TEST-User"),
            udm_object_type="users/user",
            object=kwargs.get("object", {}),
            options=["default", "ucsschoolTeacher"],
        )

    return _func


@pytest.fixture
def get_listener_user_remove_object():
    def _func(**kwargs):
        return ListenerUserRemoveObject(
            dn=kwargs.get("dn"),
            id=kwargs.get("id", "TEST-User"),
            udm_object_type="users/user",
        )

    return _func


@pytest.fixture
def per_sa_group_dispatcher(school_authority_conf, monkeypatch):
    workgroup_dn_regex.cache_clear()
    school_class_dn_regex.cache_clear()
    monkeypatch.setenv("ldap_base", "dc=ldap,dc=base")
    monkeypatch.setenv("ldap_server_name", "TEST-SERVER-NAME")
    monkeypatch.setenv("ldap_server_port", "789")
    with patch(
        "ucsschool_id_connector.ldap_access.LDAPAccess",
    ):
        return IDBrokerPerSAGroupDispatcher(
            school_authority=school_authority_conf, plugin_name="id_broker-groups"
        )


@pytest.fixture
def per_sa_user_dispatcher(school_authority_conf, monkeypatch):
    workgroup_dn_regex.cache_clear()
    school_class_dn_regex.cache_clear()
    monkeypatch.setenv("ldap_base", "dc=ldap,dc=base")
    monkeypatch.setenv("ldap_server_name", "TEST-SERVER-NAME")
    monkeypatch.setenv("ldap_server_port", "789")
    with patch(
        "ucsschool_id_connector.ldap_access.LDAPAccess",
    ):
        return IDBrokerPerSAUserDispatcher(
            school_authority=school_authority_conf, plugin_name="id_broker-groups"
        )
