# coding: utf-8

"""
    UCS@school APIs

    This application exposes network resources introduced via custom plugins.  # noqa: E501

    The version of the OpenAPI document: 1.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six
from idbroker.provisioning_api.api_client import ApiClient
from idbroker.provisioning_api.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class SchoolsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete(
        self, id, school_authority, **kwargs
    ):  # noqa: E501
        """Delete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete(id, school_authority, async_req=True)
        >>> result = thread.get()

        :param id: Unique ID of LDAP object on school authority side. (required)
        :type id: str
        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        return (
            self.delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete_with_http_info(
                id, school_authority, **kwargs
            )
        )  # noqa: E501

    def delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete_with_http_info(
        self, id, school_authority, **kwargs
    ):  # noqa: E501
        """Delete  # noqa: E501

        >>> thread = api.delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete_with_http_info(id, school_authority, async_req=True)
        >>> result = thread.get()

        :param id: Unique ID of LDAP object on school authority side. (required)
        :type id: str
        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = ["id", "school_authority"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete"
                    % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and (
            "id" not in local_var_params or local_var_params["id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `id` when calling `delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete`"
            )  # noqa: E501
        # verify the required parameter 'school_authority' is set
        if self.api_client.client_side_validation and (
            "school_authority" not in local_var_params
            or local_var_params["school_authority"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `school_authority` when calling `delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete`"
            )  # noqa: E501

        if self.api_client.client_side_validation and (
            "id" in local_var_params and len(local_var_params["id"]) < 1  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `id` when calling `delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete`, length must be greater than or equal to `1`"
            )  # noqa: E501
        if self.api_client.client_side_validation and (
            "school_authority" in local_var_params
            and len(local_var_params["school_authority"]) < 1  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `school_authority` when calling `delete_ucsschool_apis_provisioning_v1_school_authority_schools_id_delete`, length must be greater than or equal to `1`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "id" in local_var_params:
            path_params["id"] = local_var_params["id"]  # noqa: E501
        if "school_authority" in local_var_params:
            path_params["school_authority"] = local_var_params["school_authority"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["OAuth2PasswordBearer"]  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            "/ucsschool/apis/provisioning/v1/{school_authority}/schools/{id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get(
        self, id, school_authority, **kwargs
    ):  # noqa: E501
        """Get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get(id, school_authority, async_req=True)
        >>> result = thread.get()

        :param id: Unique ID of LDAP object on school authority side. (required)
        :type id: str
        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: School
        """
        kwargs["_return_http_data_only"] = True
        return self.get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get_with_http_info(
            id, school_authority, **kwargs
        )  # noqa: E501

    def get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get_with_http_info(
        self, id, school_authority, **kwargs
    ):  # noqa: E501
        """Get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get_with_http_info(id, school_authority, async_req=True)
        >>> result = thread.get()

        :param id: Unique ID of LDAP object on school authority side. (required)
        :type id: str
        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(School, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["id", "school_authority"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and (
            "id" not in local_var_params or local_var_params["id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `id` when calling `get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get`"
            )  # noqa: E501
        # verify the required parameter 'school_authority' is set
        if self.api_client.client_side_validation and (
            "school_authority" not in local_var_params
            or local_var_params["school_authority"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `school_authority` when calling `get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get`"
            )  # noqa: E501

        if self.api_client.client_side_validation and (
            "id" in local_var_params and len(local_var_params["id"]) < 1  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `id` when calling `get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get`, length must be greater than or equal to `1`"
            )  # noqa: E501
        if self.api_client.client_side_validation and (
            "school_authority" in local_var_params
            and len(local_var_params["school_authority"]) < 1  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `school_authority` when calling `get_ucsschool_apis_provisioning_v1_school_authority_schools_id_get`, length must be greater than or equal to `1`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "id" in local_var_params:
            path_params["id"] = local_var_params["id"]  # noqa: E501
        if "school_authority" in local_var_params:
            path_params["school_authority"] = local_var_params["school_authority"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["OAuth2PasswordBearer"]  # noqa: E501

        response_types_map = {
            200: "School",
            422: "HTTPValidationError",
        }

        return self.api_client.call_api(
            "/ucsschool/apis/provisioning/v1/{school_authority}/schools/{id}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head(
        self, id, school_authority, **kwargs
    ):  # noqa: E501
        """Head  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head(id, school_authority, async_req=True)
        >>> result = thread.get()

        :param id: Unique ID of LDAP object on school authority side. (required)
        :type id: str
        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head_with_http_info(
            id, school_authority, **kwargs
        )  # noqa: E501

    def head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head_with_http_info(
        self, id, school_authority, **kwargs
    ):  # noqa: E501
        """Head  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head_with_http_info(id, school_authority, async_req=True)
        >>> result = thread.get()

        :param id: Unique ID of LDAP object on school authority side. (required)
        :type id: str
        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["id", "school_authority"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head"
                    % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and (
            "id" not in local_var_params or local_var_params["id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `id` when calling `head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head`"
            )  # noqa: E501
        # verify the required parameter 'school_authority' is set
        if self.api_client.client_side_validation and (
            "school_authority" not in local_var_params
            or local_var_params["school_authority"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `school_authority` when calling `head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head`"
            )  # noqa: E501

        if self.api_client.client_side_validation and (
            "id" in local_var_params and len(local_var_params["id"]) < 1  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `id` when calling `head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head`, length must be greater than or equal to `1`"
            )  # noqa: E501
        if self.api_client.client_side_validation and (
            "school_authority" in local_var_params
            and len(local_var_params["school_authority"]) < 1  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `school_authority` when calling `head_ucsschool_apis_provisioning_v1_school_authority_schools_id_head`, length must be greater than or equal to `1`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "id" in local_var_params:
            path_params["id"] = local_var_params["id"]  # noqa: E501
        if "school_authority" in local_var_params:
            path_params["school_authority"] = local_var_params["school_authority"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["OAuth2PasswordBearer"]  # noqa: E501

        response_types_map = {
            200: "object",
            422: "HTTPValidationError",
        }

        return self.api_client.call_api(
            "/ucsschool/apis/provisioning/v1/{school_authority}/schools/{id}",
            "HEAD",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )

    def post_ucsschool_apis_provisioning_v1_school_authority_schools_post(
        self, school_authority, school, **kwargs
    ):  # noqa: E501
        """Post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_ucsschool_apis_provisioning_v1_school_authority_schools_post(school_authority, school, async_req=True)
        >>> result = thread.get()

        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param school: (required)
        :type school: School
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: School
        """
        kwargs["_return_http_data_only"] = True
        return self.post_ucsschool_apis_provisioning_v1_school_authority_schools_post_with_http_info(
            school_authority, school, **kwargs
        )  # noqa: E501

    def post_ucsschool_apis_provisioning_v1_school_authority_schools_post_with_http_info(
        self, school_authority, school, **kwargs
    ):  # noqa: E501
        """Post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_ucsschool_apis_provisioning_v1_school_authority_schools_post_with_http_info(school_authority, school, async_req=True)
        >>> result = thread.get()

        :param school_authority: Identifier of the school authority this object originates from. (required)
        :type school_authority: str
        :param school: (required)
        :type school: School
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(School, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = ["school_authority", "school"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_ucsschool_apis_provisioning_v1_school_authority_schools_post" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'school_authority' is set
        if self.api_client.client_side_validation and (
            "school_authority" not in local_var_params
            or local_var_params["school_authority"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `school_authority` when calling `post_ucsschool_apis_provisioning_v1_school_authority_schools_post`"
            )  # noqa: E501
        # verify the required parameter 'school' is set
        if self.api_client.client_side_validation and (
            "school" not in local_var_params or local_var_params["school"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `school` when calling `post_ucsschool_apis_provisioning_v1_school_authority_schools_post`"
            )  # noqa: E501

        if self.api_client.client_side_validation and (
            "school_authority" in local_var_params
            and len(local_var_params["school_authority"]) < 1  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `school_authority` when calling `post_ucsschool_apis_provisioning_v1_school_authority_schools_post`, length must be greater than or equal to `1`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "school_authority" in local_var_params:
            path_params["school_authority"] = local_var_params["school_authority"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "school" in local_var_params:
            body_params = local_var_params["school"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["OAuth2PasswordBearer"]  # noqa: E501

        response_types_map = {
            201: "School",
            422: "HTTPValidationError",
        }

        return self.api_client.call_api(
            "/ucsschool/apis/provisioning/v1/{school_authority}/schools",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get("_request_auth"),
        )
