import sys
from typing import Callable, Mapping
from unittest.mock import MagicMock

import pytest
from fastapi import FastAPI

from id_broker_common.plugin_reg import router

# We do not want to run update_openapi_client for unittests, hence we have to mock the module before the tests.
sys.modules["openapi_client_udm"] = MagicMock()
sys.modules["openapi_client_udm.exceptions"] = MagicMock()
sys.modules["openapi_client_udm.rest"] = MagicMock()


class FakeOPA:
    @classmethod
    async def check_policy_true_or_raise(cls, *_args, **_kwargs):
        return True


@pytest.fixture(scope="session")
def app():
    return FastAPI()


@pytest.fixture(scope="session")
def fake_opa():
    """Returns a class with a method check_policy_true -> True"""
    return FakeOPA


async def _async_dict():
    return {}


@pytest.fixture(scope="session")
def async_dict():
    """Returns an async method that returns an empty dict"""
    return _async_dict


class AsyncIter:
    def __init__(self, *args, **kwargs):
        self.items = []

    async def __aiter__(self):
        for item in self.items:
            yield item


@pytest.fixture(scope="session")
def async_iterable():
    """Returns an async method that returns an empty AsyncIter object"""
    return AsyncIter


@pytest.fixture(scope="session")
def dependency_overrides(app):
    """Override app dependencies temporarily"""

    def _standard_overrides(overrides: Mapping[Callable, Callable]):
        app.include_router(router)
        # let's override the dependencies, so that we don't test more than we want
        for original, override in overrides.items():
            print(f"overriding {original} with {override}")
            app.dependency_overrides[original] = override  # todo typehints?

    yield _standard_overrides
    app.dependency_overrides = {}


async def _async_str():
    return ""


@pytest.fixture(scope="session")
def async_str():
    """Returns an async method that returns an empty str"""
    return _async_str
