# Jenkins Jobs

## create a performance test environment in KVM

- Job to create performance env https://jenkins2022.knut.univention.de/view/UCS@school/job/UCSschool-5.0/view/Environments/job/IdBrokerPerformanceEnvironment/
- Job to build template, e.g. after UCS patch level update https://jenkins2022.knut.univention.de/view/All/job/UCS-5.0/job/UCS-5.0-6/view/all/job/CreateSchoolIDBrokerEnvKtGetTemplate/


## ID Broker Performance (EC2)

* cfg file - autotest-247-ucsschool-id-broker-perf-ec2.cfg
* starts a jumphost to run the test on the external testing env

## ID Broker Performance (KVM)

* cfg file - `autotest-247-ucsschool-id-broker-perf.cfg`
* starts id broker template environment and a jumphost to run the tests

## Environment variables

These variables are set in the cfg file:

* `UCS_ENV_BROKER_LDAPS` - all the broker systems with ldap server
* `UCS_ENV_TRAEGER1_FQDN` - fqdn of traeger1
* `UCS_ENV_TRAEGER2_FQDN` - fqdn of traeger2
* `UCS_ENV_ANSIBLE_SSH_USER` - ssh user for traeger systems
* `UCS_ENV_ANSIBLE_SSH_USER_BROKER` - ssh user for broker systems
* `UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY` - ssh key for traeger systems
* `UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY_BROKER` - ssh key for broker systems
* `UCS_ENV_ANSIBLE_SUDO_PASSWORD_BROKER` - sudo password for broker systems
* `UCS_ENV_LOCUST_VARS` - locust settings
* `UCS_ENV_SELF_DISCLOSURE_FQDN` - fqdn of self disclosure system
* `UCS_ENV_PROVISIONING_FQDN` - fqdn of provisioing system
* `UCS_ENV_KEYCLOAK_FQDN` - fqdn of keycloak system
* `UCS_ENV_TEST_APP_FQDN` - fqdn of univention-test-app system
* `UCS_ENV_UCS_TEST_EXTRA_ARGS` - extra parameters for the ucs-test run

These variables are stored on the jenkins server
(id-broker-secrets-external.env, id-broker-secrets-internal.env), see git repo
jenkins-data.

* `UCS_ENV_TEST_APP_SECRET` - client secret of univention-test-app
* `UCS_ENV_GIT_RESULTS_ACCESS_TOKEN` - git token for results repo (only used in jenkins job)
* `UCS_ENV_PROVISIONING_USER_TRAEGER1_SECRET` - password of provisioning user for traeger1
* `UCS_ENV_PROVISIONING_USER_TRAEGER2_SECRET` - password of provisioning user for traeger2


# Usage

## Ansible test in ec2 testing environment
```
export UCS_ENV_BROKER_LDAPS="10.189.34.31 10.189.34.41 10.189.34.42 10.189.34.61 10.189.34.62 10.189.34.81"
export UCS_ENV_TRAEGER1_FQDN=traeger1.school1.dev.univention-id-broker.com
export UCS_ENV_TRAEGER2_FQDN=traeger2.school2.dev.univention-id-broker.com
export UCS_ENV_ANSIBLE_SSH_USER=root
export UCS_ENV_ANSIBLE_SSH_USER_BROKER=root
export UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY_BROKER=/home/fbotner/idbroker/id_performance_tests
export UCS_ENV_ANSIBLE_SSH_PRIVATE_KEY=/home/fbotner/ec2/keys/tech.pem

ansible-inventory -i ansible/inventory.py  --list
ansible-playbook -i ansible/inventory.py ansible/test.yml
```

## Run a locust test from workplace

```
export UCS_ENV_TRAEGER1_FQDN=traeger1.school1.dev.univention-id-broker.com
export UCS_ENV_TRAEGER2_FQDN=traeger2.school2.dev.univention-id-broker.com
export UCS_ENV_TRAEGER1_IDP_HINT=Traeger1
export UCS_ENV_TRAEGER2_IDP_HINT=Traeger2
export UCS_ENV_KEYCLOAK_FQDN=sso-broker.testing.univention-id-broker.com
export UCS_ENV_TEST_APP_FQDN=sso-broker.testing.univention-id-broker.com
export UCS_ENV_PROVISIONING_USER_TRAEGER1_SECRET=...
export UCS_ENV_PROVISIONING_USER_TRAEGER2_SECRET=...
export UCS_ENV_TEST_APP_SECRET=...
# see jenkins-data/id-broker/id-broker-secrets-external.env for secrets
export export ID_BROKER_TEST_DATA=./test-data-db/

locust --host self-disclosure.testing.univention-id-broker.com \
    --locustfile performance-tests/performance_tests/self_disclosure/student_get_metadata.py \
    --headless --users 1 --spawn-rate 1 --run-time 10s --stop-timeout 60

```
