package self_disclosure_plugin

default users_self_info = false

# Policy is true if sub and user_id are equal, neither is empty
# and the user is either a teacher or student
users_self_info {
	input.sub != ""
	input.user_id != ""
	allowed_roles := ["teacher", "student"]
	input.user_roles[_] = allowed_roles[_]
	input.sub == input.user_id
}

default groups_members = false

# Policy for school_admins.
# Disabled until it is decided how school admins are handled in the context of the ID Broker
#groups_members {
#	group_base("school_admin")
#}

# Policy for teachers. In addition to group_base the user must also be a member of the group
groups_members {
	group_base("teacher")
	input.group.users[_] == input.user.name
}

# Evaluates to true if there is a combination of roles from user and group where
# the school value is equal, the groups role is either school_class or workgroup and the users role
# is equal to the given parameter user_role
group_base(user_role) {
	role_parts_user := split(input.user.ucsschool_roles[_], ":")
	role_parts_group := split(input.group.ucsschool_roles[_], ":")
	allowed_group_roles := ["school_class", "workgroup"]
	allowed_group_roles[_] == role_parts_group[0]
	role_parts_user[0] == user_role
	role_parts_user[2] == role_parts_group[2]
}
